<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    include "include/controlloLogin.php";
    
    $impostazioniLingue= $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue",1);
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    $tipo              = "categoriaArticolo";
    $linguaSelezionata = isset($_GET["lingua"]) ? filter_input(INPUT_GET,"lingua",FILTER_SANITIZE_STRING) : $impostazioniLingue["linguaPrincipale"];
    
    $parametriRicerca = $cerca!="" ? ["tipo"=>$tipo,"nome"=>$cerca,"lingua"=>$linguaSelezionata] : ["tipo"=>$tipo,"categoriaMadre"=>0,"lingua"=>$linguaSelezionata];
    if(isset($_GET["efficacia"])) {
        $parametriRicerca["efficacia"] = filter_input(INPUT_GET, "efficacia",FILTER_SANITIZE_STRING);
    }

    if(isset($_GET["stato"])) {
        $parametriRicerca["stato"] = filter_input(INPUT_GET, "stato",FILTER_SANITIZE_STRING);
    }
    
    $parametri = array("tabella"=>"geec_categorie", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"gestioneCategorie.php");
    $ricerca->setOrdinamento(" ORDER BY posizione ASC");
    
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
        <title>Amministrazione di Geecom CMS - gestione categorie</title>

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
    </head>

    <body>

        <header>
            <?php  
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>
        <?php 

            if(isset($_GET["status"])) {
                if($_GET["status"]==1) {
                    echo"<p class=\"alert alert-success\">Utente creato</p>";
                }
                else if($_GET["status"]==2) {
                    echo"<p class=\"alert alert-success\">Utente modificato</p>";
                }
                else if($_GET["status"]==4) {
                    echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
                }
                else if($_GET["status"]==400) {
                    echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
                }
                else { //status = 5
                    echo"<p class=\"alert alert-success\">Utente eliminato</p>";
                }
            }
        ?>
         <!-- Modal box conferma cancellazione elemento-->
        <div class="modal fade" id="modalEliminaCategoria" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Eliminare la categoria?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex flex-row justify-content-center">
                        <input type="text" class="d-none" id="categoriaDaEliminare" >
                        <div class="align-self-center text-center">
                            <span class="align-self-center text-primary"><em id="nomeCategoriaDaEliminare"></em></span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-default" data-dismiss="modal">Annulla</button>
                  <button type="button" class="btn btn-primary" onclick="{eliminaCategoria('../')}" >Elimina</button>
                </div>
            </div><!-- /.modal-content -->
          </div><!-- /.modal-dialog -->
        </div><!-- /.Modal box-->

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div id="contenutoPrincipale" class="row">
                    <div class="col py-4">
                        <div class="card mb-4 box-shadow-lite">
                            <div class="card-header">
                                <span class="card-title mr-2">Elenco categorie</span>
                                <a href="creaCategoria.php?tipo=categoriaArticolo" class="btn btn-sm btn-primary" >
                                    Nuova categoria<i class="fas fa-plus ml-2"></i>
                                </a>
                            </div>
                            <div class="panel panel-default">
                                <div class="card-body collapse show">
                                    <div class="d-flex justify-content-between mb-3">
                                        <?php
                                            $ricerca->stampaSelectNumeroElementi($cerca);
                                        ?>
                                        <form class="form-inline" name="formRicerca" action="gestioneCategorie.php">
                                            <div class="input-group">
                                                <input type="text" class="d-none" name="elementiPerPagina" value="<?= $elementiPerPagina ?>">
                                                <input type="text" class="d-none" name="tipo" value="<?= $tipo ?>">
                                                <input type="text" class="form-control" id="cerca" aria-describedby="cerca" name="cerca" placeholder="Cerca..." value="<?= $cerca ?>">
                                                <select name="lingua" class="custom-select">
                                                    <option value="" <?= (($linguaSelezionata=="") ? "selected" : ""); ?>>Tutte le lingue</option>
                                                    <?php 
                                                        foreach($lingue as $lingua) {
                                                    ?>
                                                            <option value="<?= $lingua ?>" <?=(($linguaSelezionata==$lingua) ? "selected" : ""); ?>><?= $lingua ?></option>
                                                    <?php
                                                        }
                                                    ?>
                                                </select>
                                                <div class="input-group-append">
                                                    <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i></button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <div id="elencoCategorie" class="table-responsive table-sm">
                                        <?php

                                            if(isset($_GET["pag"])) {
                                                $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                            }
                                            else {
                                                $ris = $ricerca->eseguiRicerca(1);
                                            }

                                            $colonne = array("ID","Lingua","Nome","Numero articoli","Visualizzazioni totali","SEO","Posizione","");
                                            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);

                                            $tabella->setTipo("normale");
                                            while($categoria = $ris->fetch_assoc()) {
                                                $urlCategoria        = GeneratoreUrl::creaUrlCategoria($categoria, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                                                $nomeEscape          = filter_var($categoria["nome"],FILTER_SANITIZE_ADD_SLASHES);
                                                $posizionePrecedente = ($categoria["posizione"]<=1) ? 1 : $categoria["posizione"] - 1;
                                                $posizioneSuccesiva  = $categoria["posizione"] +1;
                                                $dataCreazione = date("d/m/Y",strtotime($categoria["dataCreazione"]));
                                                $azioni = ["visualizza"=>$urlCategoria,"spostaSu"=>"spostaCategoria({$categoria["id"]},$posizionePrecedente)","spostaGiu"=>"spostaCategoria({$categoria["id"]},$posizioneSuccesiva)","modifica"=>"creaCategoria.php?id={$categoria["id"]}","elimina"=>"apriPopupEliminaCategoria({$categoria["id"]},'{$nomeEscape}')"];

                                                if($categoria["punteggioSeo"]=="scadente") {                                            
                                                    $stringaPunteggioSEO = "<i class=\"far fa-frown text-danger\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"scadente\"></i>";
                                                }
                                                else if($categoria["punteggioSeo"]=="discreta") {
                                                    $stringaPunteggioSEO = "<i class=\"far fa-meh text-warning\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"discreta\"></i>";
                                                }
                                                else if($categoria["punteggioSeo"]=="buona") {
                                                    $stringaPunteggioSEO = "<i class=\"far fa-smile text-success\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"buona\"></i>";
                                                }
                                                else {
                                                    $stringaPunteggioSEO = "";
                                                }

                                                $formPosizione = "<form class=\"d-inline-flex mr-sm-1\">
                                                    <div class=\"input-group input-group-sm d-flex align-items-center\">
                                                        <input type=\"number\" id=\"nuovaPosizioneCategoria{$categoria["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$categoria["posizione"]}\">
                                                        <div class=\"input-group-append\">
                                                            <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaCategoriaInput({$categoria["id"]})\">Salva</button>
                                                        </div>
                                                    </div>
                                                </form>";

                                                $queryNumArticoli = "SELECT COUNT(*) FROM geecB_contenuti WHERE categoria={$categoria["id"]} OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre={$categoria["id"]})";
                                                $risNumArticoli = $geecomDb->eseguiQueryLettura($queryNumArticoli);
                                                $numeroArticoli = $risNumArticoli->fetch_array(MYSQLI_NUM);

                                                $visualizzazioniTotali   = $geecomDb->sommaValoriColonna("numeroVisite", "geecB_contenuti", array("categoria"=>$categoria["id"]));
                                                if(!is_numeric($visualizzazioniTotali)) {
                                                    $visualizzazioniTotali = 0;
                                                }

                                                $tabella->aggiungiNuovaRiga(array($categoria["id"],"<img class=\"bandiera\" src=\"../".percorsoImmagineBandiera($categoria["lingua"])."\">","<a href=creaCategoria.php?id={$categoria["id"]}><b>{$categoria["nome"]}</b></a><span class=\"d-block text-muted\">$urlCategoria</span>",$numeroArticoli[0],$visualizzazioniTotali,$stringaPunteggioSEO,$formPosizione),$azioni);

                                                // cerco e stampo eventuali sottocategorie
                                                $querySottoCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre={$categoria["id"]} ORDER BY posizione ASC";
                                                $risSottoCategorie   = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                while($sottoCategoria = $risSottoCategorie->fetch_assoc()) {
                                                    $urlSottoCategoria   = GeneratoreUrl::creaUrlCategoria($sottoCategoria, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                                                    $nomeEscape          = filter_var($sottoCategoria["nome"],FILTER_SANITIZE_ADD_SLASHES);
                                                    $posizionePrecedente = ($sottoCategoria["posizione"]<=1) ? 1 : $sottoCategoria["posizione"] - 1;
                                                    $posizioneSuccesiva  = $sottoCategoria["posizione"] +1;
                                                    $dataCreazione = date("d/m/Y",strtotime($sottoCategoria["dataCreazione"]));
                                                    $azioni = ["visualizza"=>$urlSottoCategoria,"spostaSu"=>"spostaCategoria({$sottoCategoria["id"]},$posizionePrecedente)","spostaGiu"=>"spostaCategoria({$sottoCategoria["id"]},$posizioneSuccesiva)","modifica"=>"creaCategoria.php?id={$sottoCategoria["id"]}","elimina"=>"apriPopupEliminaCategoria({$sottoCategoria["id"]},'{$nomeEscape}')"];

                                                    $numeroArticoliSottoCategoria = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo","categoria"=>$sottoCategoria["id"]));

                                                    $visualizzazioniTotaliSottoCategoria = $geecomDb->sommaValoriColonna("numeroVisite", "geecB_contenuti", array("categoria"=>$sottoCategoria["id"]));
                                                    if(!is_numeric($visualizzazioniTotaliSottoCategoria)) {
                                                        $visualizzazioniTotaliSottoCategoria = 0;
                                                    }

                                                    if($sottoCategoria["punteggioSeo"]=="scadente") {                                            
                                                        $stringaPunteggioSEO = "<i class=\"far fa-frown text-danger\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"scadente\"></i>";
                                                    }
                                                    else if($sottoCategoria["punteggioSeo"]=="discreta") {
                                                        $stringaPunteggioSEO = "<i class=\"far fa-meh text-warning\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"discreta\"></i>";
                                                    }
                                                    else if($sottoCategoria["punteggioSeo"]=="buona") {
                                                        $stringaPunteggioSEO = "<i class=\"far fa-smile text-success\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"buona\"></i>";
                                                    }
                                                    else {
                                                        $stringaPunteggioSEO = "";
                                                    }

                                                    $formPosizione = "<form class=\"d-inline-flex mr-sm-1\">
                                                        <div class=\"input-group input-group-sm d-flex align-items-center\">
                                                            <input type=\"number\" id=\"nuovaPosizioneCategoria{$sottoCategoria["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$sottoCategoria["posizione"]}\">
                                                            <div class=\"input-group-append\">
                                                                <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaCategoriaInput({$sottoCategoria["id"]})\">Salva</button>
                                                            </div>
                                                        </div>
                                                    </form>";

                                                    $tabella->aggiungiNuovaRiga(array($sottoCategoria["id"],"<img class=\"bandiera\" src=\"../".percorsoImmagineBandiera($sottoCategoria["lingua"])."\">","<a href=creaCategoria.php?id={$sottoCategoria["id"]}><b> - {$sottoCategoria["nome"]}</b></a><span class=\"d-block text-muted\">$urlSottoCategoria</span>",$numeroArticoliSottoCategoria,$visualizzazioniTotaliSottoCategoria,$stringaPunteggioSEO,$formPosizione),$azioni);

                                                    // cerco e stampo eventuali sottocategorie della sottocategoria
                                                    $querySottoCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre={$sottoCategoria["id"]} ORDER BY posizione ASC";
                                                    $risSottoCategorieSottoCategorie= $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                    while($sottoCategoriaDellaSottoCategoria = $risSottoCategorieSottoCategorie->fetch_assoc()) {
                                                        $urlSottoCategoriaDellaSottoCategoria = GeneratoreUrl::creaUrlCategoria($sottoCategoriaDellaSottoCategoria, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                                                        $nomeEscape          = filter_var($sottoCategoriaDellaSottoCategoria["nome"],FILTER_SANITIZE_ADD_SLASHES);
                                                        $posizionePrecedente = ($sottoCategoriaDellaSottoCategoria["posizione"]<=1) ? 1 : $sottoCategoriaDellaSottoCategoria["posizione"] - 1;
                                                        $posizioneSuccesiva  = $sottoCategoriaDellaSottoCategoria["posizione"] +1;
                                                        $dataCreazione = date("d/m/Y",strtotime($sottoCategoriaDellaSottoCategoria["dataCreazione"]));
                                                        $azioni = ["visualizza"=>$urlSottoCategoriaDellaSottoCategoria,"spostaSu"=>"spostaCategoria({$sottoCategoriaDellaSottoCategoria["id"]},$posizionePrecedente)","spostaGiu"=>"spostaCategoria({$sottoCategoriaDellaSottoCategoria["id"]},$posizioneSuccesiva)","modifica"=>"creaCategoria.php?id={$sottoCategoriaDellaSottoCategoria["id"]}","elimina"=>"apriPopupEliminaCategoria({$sottoCategoriaDellaSottoCategoria["id"]},'{$nomeEscape}')"];

                                                        $numeroArticoliSottoCategoria = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo","categoria"=>$sottoCategoriaDellaSottoCategoria["id"]));

                                                        $visualizzazioniTotaliSottoCategoria = $geecomDb->sommaValoriColonna("numeroVisite", "geecB_contenuti", array("categoria"=>$sottoCategoriaDellaSottoCategoria["id"]));
                                                        if(!is_numeric($visualizzazioniTotaliSottoCategoria)) {
                                                            $visualizzazioniTotaliSottoCategoria = 0;
                                                        }

                                                        if($sottoCategoria["punteggioSeo"]=="scadente") {                                            
                                                            $stringaPunteggioSEO = "<i class=\"far fa-frown text-danger\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"scadente\"></i>";
                                                        }
                                                        else if($sottoCategoria["punteggioSeo"]=="discreta") {
                                                            $stringaPunteggioSEO = "<i class=\"far fa-meh text-warning\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"discreta\"></i>";
                                                        }
                                                        else if($sottoCategoria["punteggioSeo"]=="buona") {
                                                            $stringaPunteggioSEO = "<i class=\"far fa-smile text-success\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"buona\"></i>";
                                                        }
                                                        else {
                                                            $stringaPunteggioSEO = "";
                                                        }

                                                        $formPosizione = "<form class=\"d-inline-flex mr-sm-1\">
                                                            <div class=\"input-group input-group-sm d-flex align-items-center\">
                                                                <input type=\"number\" id=\"nuovaPosizioneCategoria{$sottoCategoriaDellaSottoCategoria["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$sottoCategoriaDellaSottoCategoria["posizione"]}\">
                                                                <div class=\"input-group-append\">
                                                                    <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaCategoriaInput({$sottoCategoriaDellaSottoCategoria["id"]})\">Salva</button>
                                                                </div>
                                                            </div>
                                                        </form>";

                                                        $tabella->aggiungiNuovaRiga(array($sottoCategoriaDellaSottoCategoria["id"],"<img class=\"bandiera\" src=\"../".percorsoImmagineBandiera($sottoCategoriaDellaSottoCategoria["lingua"])."\">","<a href=creaCategoria.php?id={$sottoCategoriaDellaSottoCategoria["id"]}><b> - - {$sottoCategoriaDellaSottoCategoria["nome"]}</b></a><span class=\"d-block text-muted\">$urlSottoCategoriaDellaSottoCategoria</span>",$numeroArticoliSottoCategoria,$visualizzazioniTotaliSottoCategoria,$stringaPunteggioSEO,$formPosizione),$azioni);
                                                    }
                                                }
                                            }
                                            $tabella->stampa("rigaCategoria", 0);
                                        ?>
                                    </div>
                                    <?php
                                        $ricerca->stampaPaginazione(true,"gestioneCategorie.php");
                                    ?>
                                    </div>
                                </div>
                                <!-- /tabella -->
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </main>

        <?php 
            include "include/footer.php";

            include "include/modal/modalMenuComponenti.php";

            include "include/modal/cambiaPassword.php";

            include "include/modal/operazioneCompletata.php";

            include "include/jsBaseAreaAmministrativa.php";
        ?>
        <script>
            function spostaCategoriaInput(id) {
                var posizione = $('#nuovaPosizioneCategoria'+id).val();
                spostaCategoria(id,posizione);
            }

            function spostaCategoria(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerCategorie.php",
                    data:{
                        operazione:"spostaCategoria",
                        id:id,
                        posizione:posizione
                    },
                    success:function(result) {
                        if(result=="ok") {
                            aggiornaCategorie('../','categoriaArticolo');
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>